<?php

$upgrade_info = array();

if (file_exists("upgrade_info.php")) {
    $upgrade_info_content = file_get_contents('upgrade_info.php');
    $upgrade_info_content = json_decode($upgrade_info_content, true);
    if (!empty($upgrade_info_content)) {
        $upgrade_info = $upgrade_info_content;
    }
}

$continue_file_process = false;

if ((int)$upgrade_info['grupo_version'] == 2) {
    include 'sub_processes/version_2/update_files.php';
} else {
    $continue_file_process = true;
    include 'sub_processes/version_3/update_files.php';
}

if ($continue_file_process) {
    $page_content = [
        'title' => 'Updating Functions',
        'loading_text' => 'Updating Functions.',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=update_files&sub_process=fns_folder'
    ];
} else {
    $page_content = [
        'title' => 'Updating Database.',
        'loading_text' => 'Updating Database.',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=update_database'
    ];
}