<?php
function rrmdir($dir) {
  if (is_dir($dir)) {
    $objects = scandir($dir);
    foreach ($objects as $object) {
      if ($object != "." && $object != "..") {
        if (filetype($dir."/".$object) == "dir")
           rrmdir($dir."/".$object);
        else unlink   ($dir."/".$object);
      }
    }
    reset($objects);
    rmdir($dir);
  }
 }

 function deleteFolderContents($folderPath) {
    if (!is_dir($folderPath)) return;

    $files = scandir($folderPath);
    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;

        $fullPath = $folderPath . DIRECTORY_SEPARATOR . $file;

        if (is_dir($fullPath)) {
            // Recursively delete subfolder contents
            deleteFolderContents($fullPath);
            // Remove the empty subfolder
            rmdir($fullPath);
        } else {
            // Delete file
            unlink($fullPath);
        }
    }
}