<?php
require_once "grupo_bridge/grupo_config.php";
require_once "grupo_bridge/curl_function.php";

$old_user_data = $user_data;
$update_user = null;

if ($first == 'general' || $first == 'profile') {
    if (isset($_POST['user_id']) && !empty($_POST['user_id'])) {
        $update_user = PT_UserData($_POST['user_id']);
    }
} else if ($first == 'delete' && $pt->config->delete_account == 'on') {
    if ($delete) {
        require_once "grupo_bridge/grupo_delete_user.php";
    }
}

if (!empty($update_user)) {
    $update_request = false;
    $post_fields = [
        "api_secret_key" => $grupo_api_secret_key,
        "update" => "site_users",
        "user" => $old_user_data->email,
    ];

    if (isset($update_user->name)) {
        $post_fields["full_name"] = $update_user->name;
        $update_request = true;
    }

    if (isset($update_user->avatar)) {
        $post_fields["avatarURL"] = $update_user->avatar;
        $update_request = true;
    }

    if (isset($update_user->username)) {
        if ($old_user_data->username !== $update_user->username) {
            $post_fields["username"] = $update_user->username;
            $update_request = true;
        }
    }

    if (isset($update_user->email)) {
        if ($old_user_data->email !== $update_user->email) {
            $post_fields["email_address"] = $update_user->email;
            $update_request = true;
        }
    }



    if ($update_request) {
        $api_request_url = rtrim($grupo_web_address, "/") . "/" . "api_request/";
        $curl_response = grupo_curl_Request($api_request_url, $post_fields, false);
    }

}
?>