<?php defined('BASEPATH') or exit('No direct script access allowed');
/**
 * Module Name: Grupo Chat SSO
 * Description: Allows single sign-on between Perfex CRM and Grupo Chat script.
 * Version: 1.0.0
 * Requires at least: 2.3.*
 */

hooks()->add_action('app_init', 'grupo_chat_sso_init');
hooks()->add_action('admin_init', 'grupo_chat_sso_menu');
hooks()->add_action('staff_member_updated', 'grupo_chat_sso_sync_staff_update');
hooks()->add_action('client_updated', 'grupo_chat_sso_sync_client_update');


function grupo_chat_sso_sync_staff_update($staff_id)
{
    log_activity("grupo_chat_sso_sync_staff_update triggered for staff ID: $staff_id");
    $CI = &get_instance();
    $CI->load->model('staff_model');
    $staff = $CI->staff_model->get($staff_id);

    if (!$staff) {
        return;
    }

    $grupo_web_address = get_option('grupo_base_url');
    $api_secret_key = get_option('grupo_api_key');

    $post_fields = [
        'api_secret_key' => $api_secret_key,
        'update' => 'site_users',
        'user' => $staff->email,
        'email_address' => $staff->email,
        'full_name' => $staff->firstname . ' ' . $staff->lastname,
        'username' => $staff->staffid,
        'avatarURL' => staff_profile_image_url($staff->staffid),
    ];

    grupo_chat_sso_send_api_request($grupo_web_address, $post_fields);
}

function grupo_chat_sso_sync_client_update($client_id)
{
    $CI = &get_instance();
    $CI->load->model('clients_model');
    $client = $CI->clients_model->get($client_id);

    if (!$client) {
        return;
    }

    $grupo_web_address = get_option('grupo_base_url');
    $api_secret_key = get_option('grupo_api_key');

    $post_fields = [
        'api_secret_key' => $api_secret_key,
        'update' => 'site_users',
        'user' => $client->email,
        'email_address' => $client->email,
        'full_name' => $client->firstname . ' ' . $client->lastname,
        'avatarURL' => client_profile_image_url($client->userid),
    ];

    grupo_chat_sso_send_api_request($grupo_web_address, $post_fields);
}

function grupo_chat_sso_send_api_request($api_url, $post_fields)
{
    $api_request_url = rtrim($api_url, '/') . '/api_request/';

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $api_request_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $post_fields,
        CURLOPT_USERAGENT => 'PerfexCRM GrupoSSO'
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    if (!empty($response)) {
        $response = json_decode($response);
        if (!empty($response) && isset($response->success) && !$response->success) {
            log_activity('Grupo API Error: ' . $response->error_message);
        } elseif (isset($response->success)) {
            log_activity('Grupo API Sync Successful for user: ' . $post_fields['email_address']);
        }
    } else {
        log_activity('Grupo API No Response');
    }
}



function grupo_chat_sso_init()
{
    $CI = &get_instance();

    $token = $CI->input->get('grupo_sso_token');
    if ($token) {
        $CI->load->library('grupo_chat_sso_auth');
        $user = $CI->grupo_chat_sso_auth->verify_token($token);

        if ($user) {
            // Authenticate staff user
            $CI->session->set_userdata([
                'staff_user_id' => $user['staff_id'],
                'logged_in' => true,
            ]);
            redirect(admin_url());
        }
    }
}

function grupo_chat_sso_menu()
{
    $CI = &get_instance();

    if (is_staff_logged_in()) {
        $CI->app_menu->add_sidebar_menu_item('grupo_chat_sso', [
            'slug' => 'grupo_chat_sso',
            'name' => _l('Chatroom'),
            'icon' => 'fa fa-comments',
            'href' => admin_url('grupo_chat_sso/chatroom'),
            'position' => 60,
        ]);
    }

    if (is_client_logged_in()) {
        $CI->app_menu->add_sidebar_menu_item('grupo_chat_sso_client', [
            'slug' => 'grupo_chat_sso_client',
            'name' => _l('Chatroom'),
            'icon' => 'fa fa-comments',
            'href' => site_url('grupo_chat_sso/chatroom_client'),
            'position' => 60,
        ]);
    }
}


hooks()->add_action('admin_init', function () {
    $CI = &get_instance();

    if (is_admin()) {
        $CI->load->helper('url');

        // Register settings section with Perfex Settings API
        $CI->app->add_settings_section('grupo_chat_sso', [
            'title' => _l('Grupo Chat SSO'),
            'view' => 'grupo_chat_sso/settings', // path to settings view
            'position' => 60,
            'children' => [
                [
                    'id' => 'grupo_chat_sso_api',
                    'name' => _l('API Settings'),
                    'icon' => 'fa fa-cog',
                    'view' => 'grupo_chat_sso/settings',
                ],
            ],
        ]);
    }
});
