<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Grupo_chat_sso extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('staff_model');
    }

    public function chatroom()
    {
        $iframe_embed = false;  // You can make this configurable
        $iframe_width = '100%';
        $iframe_height = '700px';

        $grupo_web_address = get_option('grupo_base_url');
        $api_secret_key = get_option('grupo_api_key');
        $randomNumber = rand(1000, 5000);
        $password = rand(10000, 50000);

        if (is_staff_logged_in()) {
            $user = $this->staff_model->get(get_staff_user_id());
            $full_name = $user->firstname;
            $email = $user->email;
            $username = $user->firstname . $randomNumber; // or any username logic
            $avatar = staff_profile_image_url($user->staffid);
        } elseif (is_client_logged_in()) {
            $user = $this->clients_model->get(get_client_user_id());
            $full_name = $user->firstname;
            $email = $user->email;
            $username = $user->firstname . $randomNumber; // or any username logic
            $avatar = client_profile_image_url($user->userid);
        } else {
            redirect(site_url('authentication/login'));
            return;
        }

        $post_fields = [
            'api_secret_key' => $api_secret_key,
            'add' => 'login_session',
            'create_account' => 'yes',
            'email_address' => $email,
            'full_name' => $full_name,
            'username' => $username,
            'password' => $password,
            'avatarURL' => $avatar,
            'site_role' => '', // Optional site role if needed
        ];


        $api_request_url = rtrim($grupo_web_address, '/') . '/api_request/';

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $api_request_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $post_fields,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:99.0) Gecko/20100101 Firefox/99.0'
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        if (!empty($response)) {
            $response = json_decode($response);
            if (!empty($response)) {
                if ($response->success) {
                    if ($iframe_embed) {
                        $data['iframe'] = "<iframe src='{$response->auto_login_url}' width='{$iframe_width}' height='{$iframe_height}' allow='camera;microphone' frameborder='0' allowfullscreen></iframe>";

                        if (is_staff_logged_in()) {
                            // Load Admin layout
                            $this->load->view('grupo_chat_sso/chatroom', $data);
                        } elseif (is_client_logged_in()) {
                            // Load Client (customer) layout
                            $this->load->view('grupo_chat_sso/chatroom', $data);
                        } else {
                            redirect(site_url('authentication/login'));
                        }
                    } else {
                        header("Location: {$response->auto_login_url}");
                        exit;
                    }
                    return;
                } else {
                    show_error($response->error_message);  // Show API error message
                }
            } else {
                show_error('Invalid API response');
            }
        } else {
            show_error('Could not connect to Grupo API');
        }


    }

}
