<?php

defined('PLUGINPATH') or exit('No direct script access allowed');

/*
  Plugin Name: Grupo Chat Integration
  Description: Plugin to integrate with Grupo Chat in order to enable Single Sign-On (SSO) functionality.
  Version: 1.0
  Requires at least: 3.0
  Author: Baevox
  Author URL: https://grupochat.co/
 */

//add menu item to left menu
app_hooks()->add_filter('app_filter_staff_left_menu', function ($sidebar_menu) {
    if(get_grupo_chat_sso_setting("grupo_chat_status") === 'yes'){
    $sidebar_menu["grupo_chat_sso"] = array(
        "name" => "grupo_chat_menu",
        "url" => "chatroom",
        "class" => "message-circle",
        "position" => 6,
    );
    }

    return $sidebar_menu;
});


//add menu item to left menu
app_hooks()->add_filter('app_filter_client_left_menu', function ($sidebar_menu) {
   if(get_grupo_chat_sso_setting("grupo_chat_status") === 'yes'){
    $sidebar_menu["grupo_chat_sso"] = array(
        "name" => "grupo_chat_menu",
        "url" => "chatroom",
        "class" => "message-circle",
        "position" => 6,
    );
    }

    return $sidebar_menu;
});

app_hooks()->add_filter('app_hook_before_signout', function ($data) {
       $gr_session = \Config\Services::session();
       $gr_session->remove("grupo_auto_login_url");
        
});
app_hooks()->add_filter('app_hook_data_delete', function ($data) {
    
    var_dump($data);
}); 

app_hooks()->add_filter('app_hook_data_update', function ($data) {
    if (
        isset($data['table_without_prefix'], $data['data']) &&
        $data['table_without_prefix'] === 'users' &&
        isset($data['id']) &&
        (!empty($data['data']['first_name']) || !empty($data['data']['image']))
    ) {
        $user_id = $data['id'];

        $db = db_connect('default');
        $sql_query = "SELECT email FROM " . get_db_prefix() . "users WHERE id = ?";
        $query = $db->query($sql_query, [$user_id]);
        $result = $query->getRow();

        if ($result) {
            $grupo_post_data = [
                "api_secret_key" => get_grupo_chat_sso_setting("grupo_chat_api_key"),
                "update"         => "site_users",
                "user"           => $result->email,
            ];

            if (!empty($data['data']['first_name'])) {
                $grupo_post_data["full_name"] = $data['data']['first_name'];
            }

            if (!empty($data['data']['image'])) {
                $grupo_post_data["avatarURL"] = get_avatar($data['data']['image']);
            }

            $grupo_curl_response = grupo_curl_request($grupo_post_data);
        }
    }

    return $data;
});

//add admin setting menu item
app_hooks()->add_filter('app_filter_admin_settings_menu', function ($settings_menu) {
    $settings_menu["plugins"][] = array("name" => "grupo_chat_sso", "url" => "grupo_chat_sso_settings");
    return $settings_menu;
});

//install dependencies
register_installation_hook("Grupo_chat_sso", function ($item_purchase_code) {
    $db = db_connect('default');
    $dbprefix = get_db_prefix();
    
        $sql_query = "CREATE TABLE IF NOT EXISTS `" . $dbprefix . "grupo_chat_sso_settings` (
        `setting_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
        `setting_value` mediumtext COLLATE utf8_unicode_ci NOT NULL,
        `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'app',
        `deleted` tinyint(1) NOT NULL DEFAULT '0',
        UNIQUE KEY `setting_name` (`setting_name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    $db->query($sql_query);

    $sql_query = "INSERT INTO `" . $dbprefix . "grupo_chat_sso_settings` (`setting_name`, `setting_value`, `deleted`) VALUES
                ('grupo_chat_url', null, 0),
                ('grupo_chat_api_key', null, 0),
                ('grupo_chat_status', 'no', 0),
                ('grupo_chat_open_parent_window', 'yes', 0);";
    $db->query($sql_query);
});

app_hooks()->add_filter('app_filter_action_links_of_Grupo_chat_sso', function () {
    $action_links_array = array(
        anchor(get_uri("grupo_chat_sso"), "Grupo_chat_sso"),
        anchor(get_uri("grupo_chat_sso_settings"), "Grupo Chat Integration"),
    );

    return $action_links_array;
});

register_uninstallation_hook("Grupo_chat_sso", function () {
    $dbprefix = get_db_prefix();
    $db = db_connect('default');

    $sql_query = "DROP TABLE IF EXISTS `" . $dbprefix . "grupo_chat_sso_settings`;";
    $db->query($sql_query);
});
