<?php

/**
 * get the defined config value by a key
 * @param string $key
 * @return config value
 */
if (!function_exists("get_grupo_chat_sso_setting")) {
    function get_grupo_chat_sso_setting($key = "")
    {
        $config = new Grupo_chat_sso\Config\Grupo_chat_sso();

        $setting_value = get_array_value($config->app_settings_array, $key);
        if ($setting_value !== null) {
            return $setting_value;
        } else {
            return "";
        }
    }
}

if (!function_exists("grupo_curl_request")) {
    function grupo_curl_request($grupo_post_data = null, $grupo_url = null)
    {
        if (empty($grupo_url)) {
            $grupo_url = get_grupo_chat_sso_setting("grupo_chat_url");
        }

        $grupo_curl_response = null;

        if (!empty($grupo_url)) {
            $grupo_api_request_url = rtrim($grupo_url, "/") . "/api_request/";
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => $grupo_api_request_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 5,
                CURLOPT_TIMEOUT => 15,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_0,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => http_build_query($grupo_post_data),
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/x-www-form-urlencoded",
                ],
            ]);
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            if ($err) {
                $grupo_curl_response = null;
            } else {
                $grupo_curl_response = json_decode($response);
            }
        }
        return $grupo_curl_response;
    }
}

/**
 * link the css files
 *
 * @param array $array
 * @return print css links
 */
if (!function_exists("grupo_chat_sso_load_css")) {
    function grupo_chat_sso_load_css(array $array)
    {
        $version = get_setting("app_version");

        foreach ($array as $uri) {
            echo "<link rel='stylesheet' type='text/css' href='" .
                base_url(PLUGIN_URL_PATH . "Grupo_chat_sso/$uri") .
                "?v=$version' />";
        }
    }
}

if (!function_exists("grupo_chat_sso_get_source_url")) {
    function grupo_chat_sso_get_source_url($grupo_chat_sso_file = "")
    {
        if (!$grupo_chat_sso_file) {
            return "";
        }

        try {
            $file = unserialize($grupo_chat_sso_file);
            if (is_array($file)) {
                return get_source_url_of_file(
                    $file,
                    get_grupo_chat_sso_setting("grupo_chat_sso_file_path"),
                    "thumbnail",
                    false,
                    false,
                    true
                );
            }
        } catch (\Exception $ex) {
        }
    }
}
